package net.w3p.simplevokabel.model;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.util.*;
import java.text.*;

/**
 * Deserializes an Lektion. XML -> Lektion Object
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */

public class LektionDeserializer implements Deserializer {

  public LektionDeserializer() {
  }

  public Object deserialize(Element root) {
    Lektion l = new Lektion();
    try {
      Node node = root.getElementsByTagName("Description").item(0).getFirstChild();
      if (node != null) l.setDescription(node.getNodeValue());
      else l.setDescription("");

      node = root.getElementsByTagName("Lastlearned").item(0).getFirstChild();
      if (node != null) {
        String date = node.getNodeValue();
        l.setLastlearned(new SimpleDateFormat("yyyy-mm-dd").parse(date));
      } else { l.setLastlearned(new Date()); }

      NodeList words = root.getElementsByTagName("Word");
      Deserializer d = DeserializerFactory.getInstance().getDeserializer(Word.class.getName());
      for (int i=0; i<words.getLength();i++ ){
        l.add(d.deserialize((Element) words.item(i)));
      }
    }
    catch (Exception ex) {
      ex.printStackTrace();
      return null;
    }
    return l;
  }
}