package net.w3p.simplevokabel.model;

import java.util.LinkedList;
import java.util.*;

/**
 * Oh thats a module. It's a collection of words. There are some attributes like
 * description that were simply ignored in some parts of the program
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */


public class Lektion extends LinkedList {
  private String description;
  private Date lastlearned;
  private Object[] backup;

  public Lektion() {
  }

  public void setDescription(String description){
    this.description = description;
  }

  public void setLastlearned(Date lastlearned){
    this.lastlearned = lastlearned;
  }

  public String getDescription(){
    return description;
  }

  public Date getLastlearned(){
    return lastlearned;
  }

  public void shuffle(){
    //first time Bakup from preserving Word order in File when it were saved
    if (backup == null) backup = super.toArray();

    Object[] a = super.toArray();
    super.clear();
    //for efficiency reason
    int len = a.length, randomplace;
    for (int i=0; i<len; i++){
      randomplace = (int) (len * Math.random());
      // now swich a[1] with a[randomplace]
      Object one = a[i];
      a[i] = a[randomplace];
      a[randomplace] = one;
    }
    for (int i=0; i<len; i++){
      super.add(a[i]);
    }
  }

  public int getNumWords(int status){
    int count = 0;
    ListIterator li = super.listIterator();
    while (li.hasNext()){
      Word w = (Word) li.next();
      if (w.getState() != status) continue;
      count++;
    }
    return count;
  }

  public Object[] getBackup(){
    if (backup == null) return super.toArray();
    return backup;
  }
}