package net.w3p.simplevokabel.main;

import java.io.*;
import java.util.*;
import net.w3p.simplevokabel.model.*;
import javax.xml.parsers.*;
import org.apache.xml.serialize.*;
import org.w3c.dom.*;

/**
 * This is not used in the window application but in the text version in the program.
 * Start this one if you wanna enter a new module in the console.
 * but try it out first, windows consoles have some problems with umlauts.
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */

public class New {

  public New(File f, InputStream in , PrintStream out, PrintStream err) {
    try {
      out.println();

      Lektion l = new Lektion();
      BufferedReader bfr = new BufferedReader(new InputStreamReader(in));

      //File/Modulname abfragen
      if (f != null && f.exists()) {f = null; err.println("Datei existiert bereits!");}
      while (f == null) {
        out.println("Modulname (muss in gltiger Dateinamen ohne Endung sein):");
        out.print("> ");
        try {
          f = new File (bfr.readLine() + ".xml");
        }
        catch (Exception ex) {
          f = null;
          err.println("Kein gltiger Name");
        }
        if (f.exists()) {f = null; err.println("Datei existiert bereits");}
      }

      out.println("Modulbeschreibung: ");
      out.print("> ");
      l.setDescription(bfr.readLine());

      out.println();
      out.println("Wrter: (beenden mit 2xEnter)");
      Word w = null;
      int num=0;
      boolean run = true;
      while (run){
        num++;
        w = new Word();
        w.setState(0);
        out.print("Muttersprache > ");
        w.setNativeWord(bfr.readLine());
        out.print("Fremdsprache  > ");
        w.setForeignWord(bfr.readLine());
        if (w.getForeignWord().equals(new String("")) &&
            w.getNativeWord().equals(new String(""))) {run = false; continue;}
        l.add(w);
        out.println();
      }

      out.println();

      //Serializing
      DocumentBuilderFactory dbf = javax.xml.parsers.DocumentBuilderFactory.newInstance();
      DocumentBuilder db = dbf.newDocumentBuilder();
      Document d = db.newDocument();
      net.w3p.simplevokabel.model.Serializer ser =
         net.w3p.simplevokabel.model.SerializerFactory.getInstance().getSerializer(l);
      d.appendChild(ser.serialize(d, l));

      OutputFormat format  = new OutputFormat(d);
      format.setPreserveSpace(true);  //wird gebraucht dass man das xml schn rausschreiben kann...
      format.setEncoding("ISO-8859-1");
      format.setIndent(1);
      format.setIndenting(true);
      format.setDoctype(null,"Lektion.dtd");


      FileWriter fileOut = new FileWriter(f);
      XMLSerializer serial = new XMLSerializer(fileOut, format);
      serial.asDOMSerializer();
      serial.serialize(d.getDocumentElement());
      fileOut.close();

      out.println("" + (num-1) + " Wrter abgespeichert.");
    }
    catch (Exception ex) {
      ex.printStackTrace();
    }




  }

  public static void main(String[] args) {
    File f = null;
    if (args.length>0) f = new File(args[0]);
    New new1 = new New(f,System.in, System.out, System.err);
  }

  private static void printUsage(String s) {
    System.err.println(s);
    System.err.println("usage: java -cp VokTrainer.jar net.w3p.simplevokabel.main.New");
    System.exit(1);
  }
}