package net.w3p.simplevokabel.main;

import net.w3p.simplevokabel.model.*;
import javax.swing.table.*;
import javax.swing.event.TableModelListener;
import javax.swing.event.*;


/**
 * This is a simple table model that encapsulate a model.Lektion for a JTable
 * Was ugly to write.
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */

public class LektionTableModel extends AbstractTableModel {

  final String[] names = {"Muttersprache", "Fremdsprache"};
  Lektion l;

  public LektionTableModel(Lektion l) {
   super();
   this.l = l;
   if (l.size() == 0) l.add(new Word());
  }

  public int getColumnCount() { return 2; }

  public int getRowCount() { return l.size();}

  public Object getValueAt(int row, int col) {
    if (row >= l.size()) return null;
    Word w = (Word) l.get(row);
    if (col == 0) return w.getNativeWord();
    if (col == 1) return w.getForeignWord();
    return "";
  }

  public String getColumnName(int column) {return names[column];}

  public void setValueAt(Object aValue, int row, int column) {
    if (column == 0) ((Word)l.get(row)).setNativeWord((String) aValue);
    if (column == 1) ((Word)l.get(row)).setForeignWord((String) aValue);
    fireTableCellUpdated(row,column);
  }

  public boolean isCellEditable(int row, int col) {return true;}

  public Lektion getLektion() {return l;}

  public void update(){
    fireTableDataChanged();
  }

}