package net.w3p.simplevokabel.main;

import java.awt.*;
import javax.swing.*;
import com.borland.jbcl.layout.*;
import net.w3p.simplevokabel.model.*;
import java.awt.event.*;

/**
 * This dialog presents the user a nativ language word and suplies a text input field
 * for a foreign word. if the user choose 'weiter' or he press enter, this dialog
 * compare the input with the given foreign word, and provide apropriate feedback to
 * the user.
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */


public class DialogWordLearner extends JDialog {
  JPanel panel1 = new JPanel();
  JLabel jLabelNative = new JLabel();
  JButton jButtonWeiter = new JButton();
  JTextField jTextForeign = new JTextField();
  Word w;
  private boolean aborted;
  JPanel jPanel1 = new JPanel();
  FlowLayout flowLayout1 = new FlowLayout();
  JPanel jPanel2 = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  GridLayout gridLayout1 = new GridLayout();
  JPanel jPanel3 = new JPanel();
  JPanel jPanel4 = new JPanel();

  public DialogWordLearner(Word w, Frame frame, String title, boolean modal) {
    super(frame, title, modal);
    this.w = w;
    try {
      jbInit();
      pack();
      if (this.getSize().getWidth()<200) this.setSize(new Dimension(200, (int) this.getSize().getHeight()));
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension frameSize = this.getSize();
      if (frameSize.height > screenSize.height) {
        frameSize.height = screenSize.height;
      }
      if (frameSize.width > screenSize.width) {
        frameSize.width = screenSize.width;
      }
      this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }

    aborted = false;
    this.addWindowListener(new WindowAdapter(){
      public void windowClosing(WindowEvent e){
        aborted = true;
      }
    });

  }

  void jbInit() throws Exception {
    panel1.setLayout(borderLayout1);
    jButtonWeiter.setText("Weiter >");
    jButtonWeiter.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonWeiter_actionPerformed(e);
      }
    });
    jTextForeign.addKeyListener(new java.awt.event.KeyAdapter() {
      public void keyPressed(KeyEvent e) {
        jTextForeign_keyPressed(e);
      }
    });
    jPanel1.setLayout(flowLayout1);
    flowLayout1.setAlignment(FlowLayout.RIGHT);
    jPanel1.setMinimumSize(new Dimension(200, 37));
    jPanel2.setLayout(gridLayout1);
    gridLayout1.setColumns(1);
    gridLayout1.setRows(3);
    borderLayout1.setHgap(20);
    borderLayout1.setVgap(20);
    jTextForeign.setMinimumSize(new Dimension(4, 15));
    jPanel2.add(jLabelNative, null);
    jPanel2.add(jTextForeign, null);
    jPanel2.add(jPanel1, null);
    jPanel1.add(jButtonWeiter, null);
    this.getContentPane().add(jPanel3, BorderLayout.WEST);
    this.getContentPane().add(jPanel4, BorderLayout.EAST);
    this.getContentPane().add(panel1,  BorderLayout.CENTER);
    panel1.add(jPanel2, BorderLayout.CENTER);
    jLabelNative.setText(w.getNativeWord());
  }


  public boolean getResultat(){
    return w.getForeignWord().equals(jTextForeign.getText());
  }

  void jButtonWeiter_actionPerformed(ActionEvent e) {
    if (w.getForeignWord().equals(jTextForeign.getText())){
      JOptionPane.showMessageDialog(this, "Richtig");
    } else {
      JOptionPane.showMessageDialog(this, "<html><font face=\"monospace\">"+
                                          "<font color=#003F00>Richtig:&nbsp;" + w.getForeignWord() + "</font><p>" +
                                          "<font color=#7F0000>_Falsch:&nbsp;" + jTextForeign.getText() + "</font></font></html>"
                                        , "Falsch", JOptionPane.ERROR_MESSAGE);
    }
    this.hide();
  }

  void jTextForeign_keyPressed(KeyEvent e) {
    if(e.getKeyChar() == e.VK_ENTER){
      jButtonWeiter_actionPerformed(null);
    }
  }

  public boolean isAborted() {
    return aborted;
  }
}