package net.w3p.simplevokabel.main;

import java.awt.*;
import javax.swing.*;
import com.borland.jbcl.layout.*;
import javax.swing.border.*;
import net.w3p.simplevokabel.model.*;
import java.awt.event.*;

/**
 * Let's the user select a tray...
 *
 * Projekt   SimpleVokabelTrainer
 * Author    Fabian Heusser <f.heusser@w3p.ch>
 * Homepage  http://www.w3p.ch/
 *
 *
 * LEGAL NOTICE
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,USA. *
 *
 * @author Fabian Heusser <f.heusser@w3p.ch>
 * @version 1.0
 */

public class DialogTrayChooser extends JDialog {
  JPanel panel1 = new JPanel();
  XYLayout xYLayout1 = new XYLayout();
  JList jList1 = new JList();
  Border border1;
  Lektion l = null;
  JButton jButton1 = new JButton();
  Object token = new Object();

  boolean[] ret = new boolean[5];

  public DialogTrayChooser(Lektion l, Frame frame, String title, boolean modal) {
    super(frame, title, modal);
    this.l = l;
    try {
      jbInit();
      pack();
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension frameSize = this.getSize();
      if (frameSize.height > screenSize.height) {
        frameSize.height = screenSize.height;
      }
      if (frameSize.width > screenSize.width) {
        frameSize.width = screenSize.width;
      }
      this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }
  }

  void jbInit() throws Exception {
    border1 = new TitledBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED,Color.white,Color.white,new Color(93, 93, 93),new Color(134, 134, 134)),"Kasten whlen");
    panel1.setLayout(xYLayout1);
    jList1.setBackground(Color.lightGray);
    jList1.setBorder(border1);
    jList1.addKeyListener(new java.awt.event.KeyAdapter() {
      public void keyPressed(KeyEvent e) {
        jList1_keyPressed(e);
      }
    });
    jButton1.setText("Lernen >");
    jButton1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton1_actionPerformed(e);
      }
    });
    getContentPane().add(panel1);
    panel1.add(jList1,     new XYConstraints(17, 21, 134, 143));
    panel1.add(jButton1,   new XYConstraints(106, 174, 102, 37));


    DefaultListModel dlm = new DefaultListModel();
    for (int i =0; i<5; i++){
      dlm.add(i, new String("" + (i+1) + " enthlt " + l.getNumWords(i) + " Karten"));
    }
    jList1.setModel(dlm);
  }

  public boolean[] getTrays(){
    return ret;
  }

  private void jButton1_actionPerformed(ActionEvent e) {
    if (jList1.getSelectedIndex()<0 ) return;

    for (int i=0; i<ret.length; i++){ret[i] = false;}
    int[] ilist = jList1.getSelectedIndices();
    for (int i=0; i<ilist.length; i++){
      ret[ilist[i]] = true;
    }

    this.hide();
  }

  void jList1_keyPressed(KeyEvent e) {
    if (e.getKeyCode() == KeyEvent.VK_ENTER){
      jButton1_actionPerformed(null);
    }
  }

}