/*
 * Decompiled with CFR 0.152.
 */
package net.w3p.simplevokabel.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.w3p.simplevokabel.model.Deserializer;
import net.w3p.simplevokabel.model.DeserializerFactory;
import net.w3p.simplevokabel.model.Lektion;
import net.w3p.simplevokabel.model.Serializer;
import net.w3p.simplevokabel.model.SerializerFactory;
import net.w3p.simplevokabel.model.Word;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Main {
    static Class class$net$w3p$simplevokabel$model$Lektion;

    public Main(File f, InputStream in, PrintStream out, PrintStream err) {
        int kasten = 0;
        int richtig = 0;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.parse(f);
            Element root = d.getDocumentElement();
            Deserializer deser = DeserializerFactory.getInstance().getDeserializer((class$net$w3p$simplevokabel$model$Lektion == null ? (class$net$w3p$simplevokabel$model$Lektion = Main.class$("net.w3p.simplevokabel.model.Lektion")) : class$net$w3p$simplevokabel$model$Lektion).getName());
            Lektion l = (Lektion)deser.deserialize(root);
            l.shuffle();
            BufferedReader breader = new BufferedReader(new InputStreamReader(in));
            out.println();
            out.println("Lektion       ".concat(String.valueOf(String.valueOf(f.getName()))));
            out.println("Beschreibung  ".concat(String.valueOf(String.valueOf(l.getDescription()))));
            out.println();
            for (int i = 0; i < 5; ++i) {
                out.println(String.valueOf(String.valueOf(new StringBuffer("Kasten ").append(i + 1).append(" enth\u00e4lt ").append(l.getNumWords(i)).append(" Karten"))));
            }
            out.println();
            do {
                try {
                    out.print("Welche Kasten soll ge\u00fcbt werden: (1-5) ");
                    String s = breader.readLine();
                    kasten = Integer.parseInt(s);
                    if (kasten > 5 || kasten < 1) {
                        throw new Exception("Fehler in der Eingabe");
                    }
                }
                catch (Exception ex) {
                    System.err.println("Fehler bei der Eingabe");
                }
            } while (kasten > 5 || kasten < 1);
            if (l.getNumWords(--kasten) == 0) {
                System.err.println("Keine W\u00f6rter in diesem Kasten");
                System.exit(1);
            }
            ListIterator li = l.listIterator();
            int numWords = l.getNumWords(kasten);
            while (li.hasNext()) {
                Word w = (Word)li.next();
                if (w.getState() != kasten) continue;
                out.println(w.getNativeWord());
                String s = breader.readLine();
                if (s.equals(w.getForeignWord())) {
                    w.setState(w.getState() + 1);
                    out.println("> Richtig");
                    ++richtig;
                } else {
                    w.setState(w.getState() - 1);
                    System.err.println("> Falsch; Richtig w\u00e4re '".concat(String.valueOf(String.valueOf(w.getForeignWord()))));
                }
                out.println();
            }
            out.println("-------------------------");
            out.println("Statistik:");
            out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(richtig))).append(" von ").append(numWords).append(" Richtig!"))));
            d = db.newDocument();
            Serializer ser = SerializerFactory.getInstance().getSerializer(l);
            d.appendChild(ser.serialize(d, l));
            OutputFormat format = new OutputFormat(d);
            format.setPreserveSpace(true);
            format.setEncoding("ISO-8859-1");
            format.setIndent(1);
            format.setIndenting(true);
            format.setDoctype(null, "Lektion.dtd");
            File neu = new File(f.getName());
            f.renameTo(new File(String.valueOf(String.valueOf(f.getName())).concat("_")));
            FileWriter fileOut = new FileWriter(neu);
            XMLSerializer serial = new XMLSerializer(fileOut, format);
            serial.asDOMSerializer();
            serial.serialize(d.getDocumentElement());
            fileOut.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            File f;
            Process p = Runtime.getRuntime().exec("cmd");
            if (args.length != 1) {
                Main.printUsage("To few or many arguments");
            }
            if (!(f = new File(args[0])).exists()) {
                Main.printUsage("File not Found");
            }
            Main main = new Main(f, p.getInputStream(), new PrintStream(p.getOutputStream()), System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printUsage(String s) {
        System.err.println(s);
        System.err.println("usage: voktrainer.jar wordfile.xml");
        System.exit(1);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

