/*
 * Decompiled with CFR 0.152.
 */
package net.w3p.simplevokabel.main;

import javax.swing.table.AbstractTableModel;
import net.w3p.simplevokabel.model.Lektion;
import net.w3p.simplevokabel.model.Word;

public class LektionTableModel
extends AbstractTableModel {
    final String[] names = new String[]{"Muttersprache", "Fremdsprache"};
    Lektion l;

    public LektionTableModel(Lektion l) {
        this.l = l;
        if (l.size() == 0) {
            l.add(new Word());
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.l.size();
    }

    public Object getValueAt(int row, int col) {
        if (row >= this.l.size()) {
            return null;
        }
        Word w = (Word)this.l.get(row);
        if (col == 0) {
            return w.getNativeWord();
        }
        if (col == 1) {
            return w.getForeignWord();
        }
        return "";
    }

    public String getColumnName(int column) {
        return this.names[column];
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (column == 0) {
            ((Word)this.l.get(row)).setNativeWord((String)aValue);
        }
        if (column == 1) {
            ((Word)this.l.get(row)).setForeignWord((String)aValue);
        }
        this.fireTableCellUpdated(row, column);
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public Lektion getLektion() {
        return this.l;
    }

    public void update() {
        this.fireTableDataChanged();
    }
}

